//==============================================================================
// Project:		Wealth Transfers and their Economic Effects
// File name:	SIH Wealth Import and Cleaning
// Objective: 	Calculate and weight net worth data from the SIH
//
// Created: 	24/02/2021
// Modified: 	15/11/2021
//==============================================================================

clear

cd "XXXX" //	set content directory here

****************************************************************
*** Collapsing personal superannuation balances by household ***
****************************************************************

use "XXXX" //	import the SIH data here - repeat for each iteration of the SIH

gen vsuptot = VSUPGCP + VSUPNCP
rename ABSHID abshid

collapse(sum) vsuptot, by(abshid)

save "SIH 2017-18 super by household" // Change the file name depending on the iteration of the SIH

************************
*** SIH 2017-18 data ***
************************

clear

use "SIH17BH" //	Importing household level data from the Survey of Income and Housing

keep abshid vfinch vsharch vputch vprtch vsipch vdebch vibusch vplnch vinvotch vrprch vnrprch vubusch vcontch vvehich voftch votassch hvaluech liasdch liaopch liarpch liavech liainvch liaotch liaccch liahecch liasfsch sihhhwt wealthh // Keeping relevant asset and liability variables as well as household ID and weights

merge 1:1 abshid using "SIH 2017-18 super by household" //	Importing person level data on superannuation that has been collapsed by household ID

drop _merge

********************************
*** Generating key variables ***
********************************

gen year = 2018

local wealth_vars vfinch vsharch vputch vprtch vsipch vdebch vibusch vplnch vinvotch vrprch vnrprch vubusch vcontch vvehich voftch votassch hvaluech liasdch liaopch liarpch liavech liainvch liaotch liaccch liahecch liasfsch wealthh vsuptot assets liabilities

*******************************
*** Weighting the variables ***
*******************************

foreach w in `wealth_vars' {
	gen wt_pop_`w' = `w' * sihhhwt
} // Generating weighted population level wealth variables

egen mean_weight = mean(sihhhwt) // Generating the mean weight for the purpose of calculating sample level weights

gen sample_weight = sihhhwt / mean_weight // Generating a sample level weight, i.e. the population weights scaled to add up to the size of the sample

foreach w in `wealth_vars' {
	gen wt_hh_`w' = `w' * sample_weight
} // Generating weighted household level wealth variables

save "SIH 2017-18 wealth data.dta", replace

************************
*** SIH 2015-16 Data ***
************************

clear

use "SIH15BH" // Importing household level data from the Survey of Income and Housing

keep abshid vfinch vsharch vputch vprtch vsipch vdebch vibusch vplnch vinvotch vrprch vnrprch vubusch vcontch vvehich voftch votassch hvaluech  liasdch liaopch liarpch liavech liainvch liaotch liaccch liahecch liasfsch sihhhwt wealthh // Keeping relevant asset and liability variables as well as household ID and weights

merge 1:1 abshid using "SIH 2015-16 super by household" // Importing person level data on superannuation that has been collapsed by household ID

drop _merge

********************************
*** Generating key variables ***
********************************

local wealth_vars vfinch vsharch vputch vprtch vsipch vdebch vibusch vplnch vinvotch vrprch vnrprch vubusch vcontch vvehich voftch votassch hvaluech  liasdch liaopch liarpch liavech liainvch liaotch liaccch liahecch liasfsch vsuptot wealthh assets liabilities

gen year = 2016

*******************************
*** Weighting the variables ***
*******************************

foreach w in `wealth_vars' {
	gen wt_pop_`w' = `w' * sihhhwt
} // Generating weighted population level wealth variables

egen mean_weight = mean(sihhhwt) // Generating the mean weight for the purpose of calculating sample level weights

gen sample_weight = sihhhwt / mean_weight // Generating a sample level weight, i.e. the population weights scaled to add up to the size of the sample

foreach w in `wealth_vars' {
	gen wt_hh_`w' = `w' * sample_weight
} // Generating weighted household level wealth variables

save "SIH 2015-16 wealth data.dta", replace

************************
*** SIH 2013-14 Data ***
************************

clear

use "sih13bh.dta" // Importing household level data from the Survey of Income and Housing

******************************
*** Renaming the variables ***
******************************

rename ABSHID abshid
rename VFINCH vfinch
rename VSHARCH vsharch
rename VPUTCH vputch
rename VPRTCH vprtch
rename VSIPCH vsipch
rename VDEBCH vdebch
rename VIBUSCH vibusch
rename VPLNCH vplnch
rename VINVOTCH vinvotch
rename VRPRCH vrprch
rename VNRPRCH vnrprch
rename VUBUSCH vubusch
rename VCONTCH vcontch
rename VVEHICH vvehich
rename VOFTCH voftch
rename VOTASSCH votassch
rename VSUPGCH vsupgch
rename VSUPNCH vsupnch
rename HVALUECH hvaluech
rename LIASDCH liasdch
rename LIAOPCH liaopch
rename LIARPCH liarpch
rename LIAVECH liavech
rename LIAINVCH liainvch
rename LIAOTCH liaotch
rename LIACCCH liaccch
rename LIAHECCH liahecch
rename LIASFSCH liasfsch
rename SIHHHWT sihhhwth
rename WEALTHH wealthh
rename LALLDCH lalldch

keep abshid vfinch vsharch vputch vprtch vsipch vdebch vibusch vplnch vinvotch vrprch vnrprch vubusch vcontch vvehich voftch votassch vsupgch vsupnch hvaluech liasdch liaopch liarpch liavech liainvch liaotch liaccch liahecch liasfsch lalldch sihhhwt wealthh // Keeping relevant asset and liability variables as well as household ID and weights

********************************
*** Generating key variables ***
********************************

gen year = 2014

local wealth_vars vfinch vsharch vputch vprtch vsipch vdebch vibusch vplnch vinvotch vrprch vnrprch vubusch vcontch vvehich voftch votassch vsupgch vsupnch hvaluech liasdch liaopch liarpch liavech liainvch liaotch liaccch liahecch liasfsch lalldch wealthh assets liabilities 

*******************************
*** Weighting the variables ***
*******************************

foreach w in `wealth_vars' {
	gen wt_pop_`w' = `w' * sihhhwt
} // Generating weighted population level wealth variables

egen mean_weight = mean(sihhhwt) // Generating the mean weight for the purpose of calculating sample level weights

gen sample_weight = sihhhwt / mean_weight // Generating a sample level weight, i.e. the population weights scaled to add up to the size of the sample

foreach w in `wealth_vars' {
	gen wt_hh_`w' = `w' * sample_weight
} // Generating weighted household level wealth variables

save "SIH 2013-14 wealth data.dta", replace

************************
*** SIH 2011-12 Data ***
************************

clear

use "sih11bh.dta" // Importing household level data from the Survey of Income and Housing

******************************
*** Renaming the variables ***
******************************

rename ABSHID abshid
rename VFINCH vfinch
rename VSHARCH vsharch
rename VPUTCH vputch
rename VPRTCH vprtch
rename VSIPCH vsipch
rename VDEBCH vdebch
rename VIBUSCH vibusch
rename VPLNCH vplnch
rename VINVOTCH vinvotch
rename VRPRCH vrprch
rename VNRPRCH vnrprch
rename VUBUSCH vubusch
rename VCONTCH vcontch
rename VVEHICH vvehich
rename VOFTCH voftch
rename VOTASSCH votassch
rename VCHASSCH vchassch
rename VSUPGCH vsupgch
rename VSUPNCH vsupnch
rename HVALUECH hvaluech
rename LIASDCH liasdch
rename LIAOPCH liaopch
rename LIARPCH liarpch
rename LIAVECH liavech
rename LIAINVCH liainvch
rename LIAOTCH liaotch
rename LIACCCH liaccch
rename LIAHECCH liahecch
rename LIASFSCH liasfsch
rename LALLDCH lalldch
rename SIHHHWT sihhhwth
rename WEALTHH wealthh

keep abshid vfinch vsharch vputch vprtch vsipch vdebch vibusch vplnch vinvotch vrprch vnrprch vubusch vcontch vvehich voftch votassch vchassch vsupgch vsupnch hvaluech liasdch liaopch liarpch liavech liainvch liaotch liaccch liahecch liasfsch lalldch sihhhwt wealthh // Keeping relevant asset and liability variables as well as household ID and weights

********************************
*** Generating key variables ***
********************************

local wealth_vars vfinch vsharch vputch vprtch vsipch vdebch vibusch vplnch vinvotch vrprch vnrprch vubusch vcontch vvehich voftch votassch vchassch vsupgch vsupnch hvaluech liasdch liaopch liarpch liavech liainvch liaotch liaccch liahecch liasfsch lalldch wealthh assets liabilities

gen year = 2012

*******************************
*** Weighting the variables ***
*******************************

foreach w in `wealth_vars' {
	gen wt_pop_`w' = `w' * sihhhwt
} // Generating weighted population level wealth variables

egen mean_weight = mean(sihhhwt) // Generating the mean weight for the purpose of calculating sample level weights

gen sample_weight = sihhhwt / mean_weight // Generating a sample level weight, i.e. the population weights scaled to add up to the size of the sample

foreach w in `wealth_vars' {
	gen wt_hh_`w' = `w' * sample_weight
} // Generating weighted household level wealth variables

save "SIH 2011-12 wealth data.dta", replace

************************
*** SIH 2009-10 Data ***
************************

clear

use "sih10bh.dta" // Importing household level data from the Survey of Income and Housing

******************************
*** Renaming the variables ***
******************************

rename ABSHID abshid
rename VFINCH vfinch
rename VSHARCH vsharch
rename VPUTCH vputch
rename VPRTCH vprtch
rename VSIPCH vsipch
rename VDEBCH vdebch
rename VIBUSCH vibusch
rename VPLNCH vplnch
rename VINVOTCH vinvotch
rename VRPRCH vrprch
rename VNRPRCH vnrprch
rename VUBUSCH vubusch
rename VCONTCH vcontch
rename VVEHICH vvehich
* rename VOFTCH voftch
rename VOTASSCH votassch
rename VCHASSCH vchassch
rename VSUPGCH vsupgch
rename VSUPNCH vsupnch
rename HVALUECH hvaluech
rename LIASDCH liasdch
rename LIAOPCH liaopch
rename LIARPCH liarpch
rename LIAVECH liavech
rename LIAINVCH liainvch
rename LIAOTCH liaotch
rename LIACCCH liaccch
rename LIAHECCH liahecch
rename LIASFSCH liasfsch
rename SIHHHWT sihhhwth
rename WEALTHH wealthh

keep abshid vfinch vsharch vputch vprtch vsipch vdebch vibusch vplnch vinvotch vrprch vnrprch vubusch vcontch vvehich votassch vchassch vsupgch vsupnch hvaluech liasdch liaopch liarpch liavech liainvch liaotch liaccch liahecch liasfsch sihhhwt wealthh // voftch // Keeping relevant asset and liability variables as well as household ID and weights

********************************
*** Generating key variables ***
********************************

local wealth_vars vfinch vsharch vputch vprtch vsipch vdebch vibusch vplnch vinvotch vrprch vnrprch vubusch vcontch vvehich votassch vchassch vsupgch vsupnch hvaluech liasdch liaopch liarpch liavech liainvch liaotch liaccch liahecch liasfsch wealthh assets liabilities

gen year = 2010

*******************************
*** Weighting the variables ***
*******************************

foreach w in `wealth_vars' {
	gen wt_pop_`w' = `w' * sihhhwt
} // Generating weighted population level wealth variables

egen mean_weight = mean(sihhhwt) // Generating the mean weight for the purpose of calculating sample level weights

gen sample_weight = sihhhwt / mean_weight // Generating a sample level weight, i.e. the population weights scaled to add up to the size of the sample

foreach w in `wealth_vars' {
	gen wt_hh_`w' = `w' * sample_weight
} // Generating weighted household level wealth variables

save "SIH 2009-10 wealth data.dta", replace

************************
*** SIH 2005-06 Data ***
************************

clear

use "sih05bh.dta" // Importing household level data from the Survey of Income and Housing

******************************
*** Renaming the variables ***
******************************

rename ABSHID abshid
rename VFINCH vfinch
rename VSHARCH vsharch
* rename VPUTCH vputch
* rename VPRTCH vprtch
* rename VSIPCH vsipch
rename VDEBCH vdebch
rename VIBUSCH vibusch
rename VPLNCH vplnch
rename VINVOTCH vinvotch
rename VRPRCH vrprch
rename VNRPRCH vnrprch
rename VUBUSCH vubusch
rename VCONTCH vcontch
rename VVEHICH vvehich
* rename VOFTCH voftch
rename VOTASSCH votassch
rename HVALUECH hvaluech
rename LIASDCH liasdch
rename LIAOPCH liaopch
rename LIARPCH liarpch
rename LIAVECH liavech
rename LIAINVCH liainvch
rename LIAOTCH liaotch
rename LIACCCH liaccch
rename LIAHECCH liahecch
rename LIASFSCH liasfsch
rename SIHHHWT sihhhwth
rename WEALTHH wealthh
rename VSUPGCH vsupgch
rename VSUPNCH vsupnch
rename VCHASSCH vchassch
rename VTRTCH vtrtch

keep abshid vfinch vsharch vdebch vibusch vplnch vinvotch vrprch vnrprch vubusch vcontch vvehich votassch vchassch vtrtch vsupgch vsupnch hvaluech liasdch liaopch liarpch liavech liainvch liaotch liaccch liahecch liasfsch sihhhwt wealthh // vputch vprtch vsipch voftch // Keeping relevant asset and liability variables as well as household ID and weights

********************************
*** Generating key variables ***
********************************

local wealth_vars vfinch vsharch vdebch vibusch vplnch vinvotch vrprch vnrprch vubusch vcontch vvehich votassch vchassch vtrtch vsupgch vsupnch hvaluech liasdch liaopch liarpch liavech liainvch liaotch liaccch liahecch liasfsch wealthh assets liabilities

gen year = 2006

*******************************
*** Weighting the variables ***
*******************************

foreach w in `wealth_vars' {
	gen wt_pop_`w' = `w' * sihhhwt
} // Generating weighted population level wealth variables

egen mean_weight = mean(sihhhwt) // Generating the mean weight for the purpose of calculating sample level weights

gen sample_weight = sihhhwt / mean_weight // Generating a sample level weight, i.e. the population weights scaled to add up to the size of the sample

foreach w in `wealth_vars' {
	gen wt_hh_`w' = `w' * sample_weight
} // Generating weighted household level wealth variables

save "SIH 2005-06 wealth data.dta", replace

************************
*** SIH 2003-04 Data ***
************************

clear

use "sih03bh.dta" // Importing household level data from the Survey of Income and Housing

******************************
*** Renaming the variables ***
******************************

rename ABSHID abshid
rename VFINCH vfinch
rename VSHARCH vsharch
* rename VPUTCH vputch
* rename VPRTCH vprtch
* rename VSIPCH vsipch
rename VDEBCH vdebch
rename VIBUSCH vibusch
rename VPLNCH vplnch
rename VINVOTCH vinvotch
rename VRPRCH vrprch
rename VNRPRCH vnrprch
rename VUBUSCH vubusch
rename VCONTCH vcontch
rename VVEHICH vvehich
* rename VOFTCH voftch
rename VOTASSCH votassch
rename VCHASSCH vchassch
rename VSUPGCH vsupgch
rename VSUPNCH vsupnch
rename VTRTCH vtrtch
rename HVALUECH hvaluech
rename LIASDCH liasdch
rename LIAOPCH liaopch
rename LIARPCH liarpch
rename LIAVECH liavech
rename LIAINVCH liainvch
rename LIAOTCH liaotch
rename LIACCCH liaccch
rename LIAHECCH liahecch
rename LIASFSCH liasfsch
rename SIHHHWT sihhhwth
rename WEALTHH wealthh

keep abshid vfinch vsharch vdebch vibusch vplnch vinvotch vrprch vnrprch vubusch vcontch vvehich votassch vchassch vsupgch vsupnch vtrtch hvaluech liasdch liaopch liarpch liavech liainvch liaotch liaccch liahecch liasfsch sihhhwt wealthh // vputch vprtch vsipch voftch // Keeping relevant asset and liability variables as well as household ID and weights

merge 1:1 abshid using "SIH 2003-04 super by household" // Importing person level data on superannuation that has been collapsed by household ID

drop _merge

********************************
*** Generating key variables ***
********************************

local wealth_vars vfinch vsharch vdebch vibusch vplnch vinvotch vrprch vnrprch vubusch vcontch vvehich votassch vchassch vsupgch vsupnch vtrtch hvaluech  liasdch liaopch liarpch liavech liainvch liaotch liaccch liahecch liasfsch wealthh assets liabilities

gen year = 2004

*******************************
*** Weighting the variables ***
*******************************

foreach w in `wealth_vars' {
	gen wt_pop_`w' = `w' * sihhhwt
} // Generating weighted population level wealth variables

egen mean_weight = mean(sihhhwt) // Generating the mean weight for the purpose of calculating sample level weights

gen sample_weight = sihhhwt / mean_weight // Generating a sample level weight, i.e. the population weights scaled to add up to the size of the sample

foreach w in `wealth_vars' {
	gen wt_hh_`w' = `w' * sample_weight
} // Generating weighted household level wealth variables

save "SIH 2003-04 wealth data.dta", replace

****************************
*** Merging the datasets ***
****************************

merge m:m year using "SIH 2005-06 wealth data.dta", nogen

merge m:m year using "SIH 2009-10 wealth data.dta", nogen

merge m:m year using "SIH 2011-12 wealth data.dta", nogen

merge m:m year using "SIH 2013-14 wealth data.dta", nogen

merge m:m year using "SIH 2015-16 wealth data.dta", nogen

merge m:m year using "SIH 2017-18 wealth data.dta", nogen

merge m:1 year using "ABS_FY_CPI"

save "SIH Wealth.dta", replace

collapse(sum) wt_pop_vfinch wt_pop_vsharch wt_pop_vdebch wt_pop_vibusch wt_pop_vplnch wt_pop_vinvotch wt_pop_vrprch wt_pop_vnrprch wt_pop_vubusch wt_pop_vcontch wt_pop_vvehich wt_pop_votassch wt_pop_vchassch wt_pop_vsupgch wt_pop_vsupnch wt_pop_vtrtch wt_pop_vsuptot wt_pop_vsipch wt_pop_voftch wt_pop_vprtch wt_pop_vputch wt_pop_hvaluech wt_pop_liasdch wt_pop_liaopch wt_pop_liarpch wt_pop_liavech wt_pop_liainvch wt_pop_liaotch wt_pop_liaccch wt_pop_liahecch wt_pop_liasfsch wt_pop_wealthh wt_pop_assets wt_pop_liabilities, by(year)

gen month = 6

save "C:\Users\jvandenberg\OneDrive - Productivity Commission\Bequests data analysis and modelling\Jono\3 Input Data\SIH Aggregate Wealth Current", replace